/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.teastory.data.recipe.builder;

import cloud.lemonslice.teastory.recipe.bamboo_tray.BambooTraySingleInRecipe;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.TeaStory;
import xueluoanping.teastory.registry.RecipeRegister;

public class BambooTrayRecipeBuilder {
    private final Item result;
    private final Ingredient ingredient;
    private final int workTime;
    private final BambooTraySingleInRecipe.BambooTraySingleInRecipeSerializer<?> recipeSerializer;

    private BambooTrayRecipeBuilder(Item resultIn, Ingredient ingredientIn, int workTimeIn, BambooTraySingleInRecipe.BambooTraySingleInRecipeSerializer<?> serializer) {
        this.result = resultIn.m_5456_();
        this.ingredient = ingredientIn;
        this.workTime = workTimeIn;
        this.recipeSerializer = serializer;
    }

    public static BambooTrayRecipeBuilder workingRecipe(Ingredient ingredientIn, Item resultIn, int workingTimeIn, BambooTraySingleInRecipe.BambooTraySingleInRecipeSerializer<?> serializer) {
        return new BambooTrayRecipeBuilder(resultIn, ingredientIn, workingTimeIn, serializer);
    }

    public static BambooTrayRecipeBuilder outdoorsRecipe(Ingredient ingredientIn, Item resultIn, int workingTimeIn) {
        return BambooTrayRecipeBuilder.workingRecipe(ingredientIn, resultIn, workingTimeIn, (BambooTraySingleInRecipe.BambooTraySingleInRecipeSerializer)((Object)RecipeRegister.BAMBOO_TRAY_OUTDOORS_SERIALIZER.get()));
    }

    public static BambooTrayRecipeBuilder indoorsRecipe(Ingredient ingredientIn, Item resultIn, int workingTimeIn) {
        return BambooTrayRecipeBuilder.workingRecipe(ingredientIn, resultIn, workingTimeIn, (BambooTraySingleInRecipe.BambooTraySingleInRecipeSerializer)((Object)RecipeRegister.BAMBOO_TRAY_INDOORS_SERIALIZER.get()));
    }

    public static BambooTrayRecipeBuilder wetRecipe(Ingredient ingredientIn, Item resultIn, int workingTimeIn) {
        return BambooTrayRecipeBuilder.workingRecipe(ingredientIn, resultIn, workingTimeIn, (BambooTraySingleInRecipe.BambooTraySingleInRecipeSerializer)((Object)RecipeRegister.BAMBOO_TRAY_IN_RAIN_SERIALIZER.get()));
    }

    public static BambooTrayRecipeBuilder bakeRecipe(Ingredient ingredientIn, @NotNull Item resultIn, int workingTimeIn) {
        return BambooTrayRecipeBuilder.workingRecipe(ingredientIn, resultIn, workingTimeIn, (BambooTraySingleInRecipe.BambooTraySingleInRecipeSerializer)((Object)RecipeRegister.BAMBOO_TRAY_BAKE_SERIALIZER.get()));
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        this.build(consumerIn, ForgeRegistries.ITEMS.getKey((Object)this.result));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String save) {
        ResourceLocation originRes = ForgeRegistries.ITEMS.getKey((Object)this.result);
        ResourceLocation saveRes = ResourceLocation.m_135820_((String)save);
        if (saveRes.equals((Object)originRes)) {
            throw new IllegalStateException("Recipe " + saveRes + " should remove its 'save' argument");
        }
        this.build(consumerIn, saveRes);
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.ingredient, this.result, this.workTime, this.recipeSerializer));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Item result;
        private final int workingTime;
        private final RecipeSerializer<? extends BambooTraySingleInRecipe> serializer;

        public Result(ResourceLocation idIn, Ingredient ingredientIn, Item resultIn, int workingTimeIn, RecipeSerializer<? extends BambooTraySingleInRecipe> serializerIn) {
            this.id = TeaStory.rl(idIn.m_135827_(), "bamboo_tray/" + idIn.m_135815_());
            this.ingredient = ingredientIn;
            this.result = resultIn;
            this.workingTime = workingTimeIn;
            this.serializer = serializerIn;
        }

        public void m_7917_(JsonObject json) {
            json.add("ingredient", this.ingredient.m_43942_());
            json.addProperty("result", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            json.addProperty("work_time", (Number)this.workingTime);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

